<x-app-layout>
    <x-slot name="header">
        {{ __('app.profile.profile') }}
    </x-slot>

    <div class="row" id="user-profile">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="wideget-user mb-2">
                        <div class="row">
                            <div class="col-lg-12 col-md-12">
                                <div class="row">
                                    <div class="panel profile-cover">
                                        <div class="profile-cover__action bg-img"
                                            style="background:url({{loadFile($user->cover)}})"></div>
                                        <div class="profile-cover__img">
                                            <div class="profile-img-1">
                                                <img src="{{loadFile($user->avatar)}}" alt="img">
                                            </div>
                                            <div class="profile-img-content text-dark text-start">
                                                <div class="text-dark">
                                                    <h3 class="h3 mb-2">{{user()->name}}</h3>
                                                    @forelse (user()->roles as $role)
                                                    <h5 class="text-muted">{{$role->name}}</h5> <br>
                                                    @empty
                                                    <h5 class="text-muted">No Role</h5>
                                                    @endforelse
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="">
                                        <div class="social social-profile-buttons mt-5 float-end">
                                            <div class="mt-3">
                                                <a class="social-icon text-primary" href="https://www.facebook.com/"
                                                    target="_blank"></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('profile.update', $user->id) }}" method="post">
                        @csrf @method('PUT')
                        <div class="row mb-4">
                            <div class="col-lg-6">
                                <label class="form-label" id="name">Name :</label>
                                <div class="">
                                    <input type="search" class="form-control @error('name') is-invalid @enderror"
                                        name="name" value="{{ old('name', $user->name) }}" placeholder="Name">
                                </div>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-6">
                                <label class="form-label" id="phone">Phone :</label>
                                <div class="">
                                    <input type="search" class="form-control @error('phone') is-invalid @enderror"
                                        name="phone" value="{{ old('phone', $user->phone) }}" placeholder="phone">
                                </div>
                                @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="mb-4">
                            <label class="form-label" id="email">Email :</label>
                            <div class="">
                                <input type="search" class="form-control @error('email') is-invalid @enderror"
                                    name="email" value="{{ old('email', $user->email) }}" placeholder="Email">
                            </div>
                            @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-6">
                                <label class="form-label" id="avatar">Profile Image :</label>
                                <div class="">
                                    <input type="file" class="form-control @error('avatar') is-invalid @enderror"
                                        name="avatar" value="{{ old('avatar', $user->avatar) }}"
                                        placeholder="Destination avatar" accept=".jpg, .png, image/jpeg, image/png">
                                </div>
                                @error('avatar')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-lg-6">
                                <label class="form-label" id="cover">Cover Image :</label>
                                <div class="">
                                    <input type="file" class="form-control @error('cover') is-invalid @enderror"
                                        name="cover" value="{{ old('cover', $user->cover) }}"
                                        placeholder="Destination cover" accept=".jpg, .png, image/jpeg, image/png">
                                </div>
                                @error('cover')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <label class="form-label" id="bio">Bio:</label>
                            <div class="">
                                <textarea name="bio" class="content @error('bio') is-invalid @enderror"
                                    placeholder="Destination bio">{{ old('bio', $user->bio) }}</textarea>
                            </div>
                            @error('bio')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>

            {{-- Password --}}
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Change Password</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('profile.password', $user->id) }}" method="post">
                        @csrf @method('PUT')

                        <div class="mb-4">
                            <label class="form-label" id="current_password">Current Password :</label>
                            <div class="">
                                <input type="password"
                                    class="form-control @error('current_password') is-invalid @enderror"
                                    name="current_password" value="{{ old('current_password') }}"
                                    placeholder="Current Password">
                            </div>
                            @error('current_password')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label class="form-label" id="password">New Password:</label>
                            <div class="">
                                <input type="password" class="form-control @error('password') is-invalid @enderror"
                                    name="password" placeholder="Password">
                            </div>
                            @error('password')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mb-4">
                            <label class="form-label" id="password_confirmation">Confirm Password :</label>
                            <div class="">
                                <input type="password"
                                    class="form-control @error('password_confirmation') is-invalid @enderror"
                                    name="password_confirmation" placeholder="Confirmation">
                            </div>
                            @error('password_confirmation')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row my-4">
                            <button type="submit" class="btn btn-primary">Update Password</button>
                        </div>
                    </form>
                </div>
            </div>
            {{-- Account Delete --}}

            <div class="card">
                <div class="card-header">
                    <div class="card-title">Delete Account</div>
                </div>
                <div class="card-body">
                    <p>Its Advisable for you to request your data to be sent to your Email.</p>
                    <label class="custom-control custom-checkbox mb-0">
                        <input type="checkbox" class="custom-control-input" name="example-checkbox1" value="option1"
                            checked>
                        <span class="custom-control-label">Yes, Send my data to my Email.</span>
                    </label>
                </div>
                <div class="card-footer text-end">
                    {{-- <a href="javascript:void(0)" class="btn btn-primary my-1">Deactivate</a> --}}
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#modalIdDelete" class="btn btn-danger my-1">Delete Account</a>
                </div>
            </div>
        </div>
    </div>

    <x-slot name="script">
        <script src="{{asset('backend/plugins/wysiwyag/jquery.richtext.js')}}"></script>
        <script src="{{asset('backend/plugins/wysiwyag/wysiwyag.js')}}"></script>
    </x-slot>

    <x-slot name="modal">
        <!-- Modal Body -->
        <!-- if you want to close by clicking outside the modal, delete the last endpoint:data-bs-backdrop and data-bs-keyboard -->
        <div
            class="modal fade"
            id="modalIdDelete"
            tabindex="-1"
            data-bs-backdrop="static"
            data-bs-keyboard="false"

            role="dialog"
            aria-labelledby="modalTitleId"
            aria-hidden="true"
        >
            <div
                class="modal-dialog modal-dialog-scrollable modal-dialog-centered "
                role="document"
            >
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalTitleId">
                            Delete Account
                        </h5>
                        <button
                            type="button"
                            class="btn-close"
                            data-bs-dismiss="modal"
                            aria-label="Close"
                        ></button>
                    </div>
                    <form action="{{route('profile.destroy', $user->id)}}" method="post">
                        @csrf @method('DELETE')
                    <div class="modal-body">
                        <p>Are you sure you want to delete your account?</p>
                        <p>
                            <strong>Warning:</strong> This action cannot be undone.
                        </p>
                        <div class="mb-4">
                            <label class="form-label" id="password">Password:</label>
                            <div class="">
                                <input required type="password" class="form-control" name="password" placeholder="Password">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button
                            type="button"
                            class="btn btn-secondary"
                            data-bs-dismiss="modal"
                        >
                            Close
                        </button>
                        <button type="submit" class="btn btn-primary">Delete</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </x-slot>
</x-app-layout>
